using System;
using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public sealed class AdizUnityNativeCaller
    {
        //private 생성자 
        private AdizUnityNativeCaller() { }
        //private static 인스턴스 객체
        private static readonly Lazy<AdizUnityNativeCaller> _instance = new Lazy<AdizUnityNativeCaller> (() => new AdizUnityNativeCaller());
        //public static 의 객체반환 함수
        public static AdizUnityNativeCaller Instance { get { return _instance.Value; } }

#if UNITY_ANDROID && !UNITY_EDITOR
		
		private AndroidJavaObject adizNativeBridge = new AndroidJavaObject("com.hive.adiz.plugin.AdizUnityNativeBridge");

		public string GetHiveAdKeyFromPlacementId(string placementId) {
			string hiveAdKey = adizNativeBridge.Call<string>("getHiveAdKeyFromPlacementId", placementId);
			return hiveAdKey;
		}

#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern System.IntPtr Adiz_GetHiveAdKeyFromPlacementId(string identifier);

		public string GetHiveAdKeyFromPlacementId(string placementId) {
			AdizLogger.d("::Hive AdizUnityNativeCaller GetHiveAdKeyFromPlacementId() call" );
			return Marshal.PtrToStringAnsi(Adiz_GetHiveAdKeyFromPlacementId(placementId));
		}
#else
		public string GetHiveAdKeyFromPlacementId(string placementId) {
			return "";
		}
		
#endif
	}
}